<?LassoScript
// Last modified: 1/15/07 by ECL, Landmann InterActive
// Prepared for Lasso Summit 07

// FUNCTIONALITY
// This is the response page for bugs_editrecord.lasso
// There are four possible actions:
// Add - Add a new record
// Update - Update an existing record
// Upload - Upload an attachment
// Comment - Create a new comment

// Debugging
// Var:'svDebug' = 'Y';

// Converting action_params
Var:'vError' = '';
Var:'vOption' = '';
// The action_param "Action" is passed by the frm_bug.inc form to indicate whether it is an add or edit
// Action = Update, means the request was an Edit
// Action = Add, means the request was an Add
Var:'vAction' = (Action_Param:'Action');

If: $svDebug == 'Y';
	'<br>\r';
	'<b>bugs_addresponse.inc</b><br>\r';
/If;

// Checking referrer to make sure it's only posting from the Add page
// ============= ADD ========
If: $vAction == 'Add';

	// Convert action_params
	Include:'bugs_params.inc';

	// If an error was generated from the Params, no point continuing, so bail immediately
	If: $vError == '';

		// Create name to display
		Var:'vDisplayName' = $vTitle;
	
		// Construct the query to add the issue
		Var:'vSQLAddBug' = '
		INSERT INTO ' $svBugsTable'  (
			Bug_ID,
			wg_id,
			Version_ID,
			Title,
			Description,
			URL,
			Severity_ID,
			Priority_ID,
			Status_ID,
			Resolution_ID,
			Browser_ID,
			Project_ID,
			Assigned_To,
			Created_By,
			OS_ID,
			ClosedInVers_ID,
			ToBeClosedVers_ID,
			DateCreated,
			DateModified) 
		VALUES ("",
			"'($svUser_WGID)'",
			"'(Encode_SQL:(Var:'vVersion_ID'))'",
			"'(Encode_SQL:(Var:'vTitle'))'",
			"'(Encode_SQL:(Var:'vDescription'))'",
			"'(Encode_SQL:(Var:'vURL'))'",
			"'(Encode_SQL:(Var:'vSeverity_ID'))'",
			"'(Encode_SQL:(Var:'vPriority_ID'))'",
			"'(Encode_SQL:(Var:'vStatus_ID'))'",
			"'(Encode_SQL:(Var:'vResolution_ID'))'",
			"'(Encode_SQL:(Var:'vBrowser_ID'))'",
			"'(Encode_SQL:(Var:'vProject_ID'))'",
			"'(Encode_SQL:(Var:'vAssigned_To'))'",
			"'(Encode_SQL:(Var:'svUser_ID'))'",
			"'(Encode_SQL:(Var:'vOS_ID'))'",
			"'(Encode_SQL:(Var:'vClosedInVers_ID'))'",
			"'(Encode_SQL:(Var:'vToBeClosedVers_ID'))'",
			"'(Date_Format:(Date_GetCurrentDate),-DateFormat='%Q') '",
			"0000-00-00");';
	
		Inline: $IV_AddBug, -SQL=$vSQLAddBug;
			
			If: (Error_CurrentError)==(Error_NoError);

				// Get new record ID value from LAST_INSERT_ID() for link
				Inline: -SQL='SELECT LAST_INSERT_ID() AS NewBugID';
					Var:'vNewBug_ID' = (Field:'NewBugID');
				/Inline;

				// Add a Changelog entry
				Include:($svLibsPath)'add_changelog.inc';

				// If no error, Add was successful, dump out Error 1001 "Add Successful"
				Var:'vError' = '1001';
				Var:'vOption' = (Var:'vDisplayName');
		
			// There was an error
			Else;
				Var:'vError' = (Error_CurrentError);
			/If;
		
		/Inline;

	/If;

	If: $svDebug == 'Y';
		'110: vError = ' $vError '<br>\n';
		'110: vOption = ' $vOption '<br>\n';
		'110: vDisplayName = ' $vDisplayName '<br>\n';
		'110: vSQLAddBug = ' $vSQLAddBug '<br>\n';
		'110: vNewBug_ID = ' $vNewBug_ID '<br>\n';
	/If;

// ============= EDIT ========
// Action = Update, means the request came from the Edit page
Else: $vAction == 'Update';

	// Convert action_params
	Include:'bugs_params.inc';
	Var:'vBug_ID' = '';
	Var:'vBug_ID' = (Action_Param:'BugID');

	// Copying  record ID to vNewBug_ID to build link
	// This is so we can just use vNewBug_ID at bottom of page for both add and edit
	Var:'vNewBug_ID'=(Var:'vBug_ID');

	// If an error was generated from the Params, no point continuing, so bail immediately
	If: $vError == '';

		// Create name to display
		Var:'vDisplayName' = $vTitle;
	
		// Check to see if a developer is assigned
		// If they are not assigned, send them an e-mail
		// This check avoids getting multiple e-mails every time somebody updates the record
		// Also have to check to see if the developer already assigned in the database is
		// the same as the action_param
		Var:'vDeveloperID' = (CheckIfAssigned: -BugID=$vBug_ID);

		If: $svDebug == 'Y';
			'144: vDeveloperID = ' $vDeveloperID '<br>\n';
		/If;

		// Add a Changelog entry
		// This MUST be done before we update the record (doh!)
		Include:'add_changelog.inc';

		// Construct the query to Update the issue
		// Not changing the Date_Created  or Created_By field
		Var:'vSQLUpdateBug' = '
		UPDATE ' $svBugsTable ' SET
			Version_ID = "'(Encode_SQL:(Var:'vVersion_ID'))'",
			Title = "'(Encode_SQL:(Var:'vTitle'))'",
			Description = "'(Encode_SQL:(Var:'vDescription'))'",
			URL = "'(Encode_SQL:(Var:'vURL'))'",
			Severity_ID = "'(Encode_SQL:(Var:'vSeverity_ID'))'",
			Priority_ID = "'(Encode_SQL:(Var:'vPriority_ID'))'",
			Status_ID = "'(Encode_SQL:(Var:'vStatus_ID'))'",
			Resolution_ID = "'(Encode_SQL:(Var:'vResolution_ID'))'",
			Browser_ID = "'(Encode_SQL:(Var:'vBrowser_ID'))'",
			Assigned_To = "'(Encode_SQL:(Var:'vAssigned_To'))'",
			OS_ID = "'(Encode_SQL:(Var:'vOS_ID'))'",
			ClosedInVers_ID = "'(Encode_SQL:(Var:'vClosedInVers_ID'))'",
			ToBeClosedVers_ID = "'(Encode_SQL:(Var:'vToBeClosedVers_ID'))'",
			LastModified_By = "'(Var:'svUser_ID')'",
			DateModified = "'(Date_Format:(Date_GetCurrentDate),-DateFormat='%Q') '"
			WHERE Bug_ID = "' $vBug_ID '"';

		If: $svDebug == 'Y';
			'173: vSQLUpdateBug = ' $vSQLUpdateBug '<br>\n';
		/If;
	
		Inline: $IV_UpdateBugs, -SQL=$vSQLUpdateBug;
			
			If:(Error_CurrentError)==(Error_NoError);
		
				// If no error, Update was successful, dump out Error 1011 "Update Successful"
				Var:'vError' = '1011';
		
			// There was an error
			Else;
				Var:'vError' = (Error_CurrentError);
			/If;
		
		/Inline;

		If: $svDebug == 'Y';
			'191: vError = ' $vError '<br>\n';
			'191: vDisplayName = ' $vDisplayName '<br>\n';
		/If;

	// vError == ''
	/If;

// ============= ADD A COMMENT ========
// Add a Comment
Else: $vAction == 'Add Comment';

	// Convert action_params
	Include:'bugs_commentparams.inc';

	// Create name to display
	Var:'vDisplayName' = 'comment';

	// Construct the query to add the Comment
	Var:'vSQLAddBugComment' = '
	INSERT INTO ' $svCommentsTable'  (
		Comment_ID,
		Bug_ID,
		wg_id,
		Comment_Text,
		Created_By,
		DateCreated) 
	VALUES (
		"",
		"'(Encode_SQL:(Var:'vBug_ID'))'",
		"'($svUser_WGID)'",
		"'(Encode_SQL:(Var:'vComment_Text'))'",
		"'(Var:'svUser_ID')'",
		"'(Date_Format:(Date_GetCurrentDate),-DateFormat='%Q') '"
		);';


		If: $svDebug == 'Y';
			'227: vSQLAddBugComment = ' $vSQLAddBugComment '<br>\n';
		/If;

	Inline: $IV_AddComments, -SQL=$vSQLAddBugComment;
		
		// Get new record ID value from LAST_INSERT_ID() for link
		Inline: -SQL='SELECT LAST_INSERT_ID() AS NewCommentID';
			Var:'vNewComment_ID' = (Field:'NewCommentID');
		/Inline;

		// Add a Changelog entry
		Include:($svLibsPath)'add_changelog.inc';

		If: $svDebug == 'Y';
			'242: SQL_Add_ChangeTableComment = ' $SQL_Add_ChangeTableComment '<br>\n';
		/If;


		If:(Error_CurrentError)==(Error_NoError);
	
			// If no error, Add was successful, dump out Error 1001 "Add Successful"
			If: $svDebug == 'Y';
				'250: vError = ' $vError '<br>\n';
				'250: vDisplayName = ' $vDisplayName '<br>\n';
			/If;
			Var:'vError' = '1001';
			Var:'vOption' = (Var:'vDisplayName');
	
		// There was an error
		Else;
			Var:'vError' = (Error_CurrentError);
		/If;
	
	/Inline;


// ============= DELETE ========
Else: $vAction == 'Delete';

	// Convert action_params
	Var:'vBug_ID'=(Action_Param:'BugID');
		
	// Build the Delete Query
	Var:'vSQLDeleteQuery' = (string);
	Var:'vSQLDeleteQuery' = 'DELETE FROM ' $svSiteDatabase'.'$svBugsTable ' WHERE Bug_ID = "' $vBug_ID '"';
	
	// Delete the record
	Inline: $IV_SearchBugs, -SQL=$vSQLDeleteQuery;
		// If delete successful, output 1023 "Deletion Successful" and go ahead and delete attachments,
		If: (Error_Code) == '0';
			Var:'vError' = '1023';
			Var:'vOption' = $vBug_ID;

			// Delete the Attachments
			Var:'vSQLDeleteAttachmentsQuery' = 'DELETE FROM ' $svSiteDatabase'.'$svAttachmentsTable ' WHERE Bug_ID = "' $vBug_ID '"';
			Inline: $IV_SearchAttachments, -SQL=$vSQLDeleteAttachmentsQuery; /Inline;

			// Delete the Comments
			Var:'SQLDeleteComments' = 'DELETE FROM ' $svCommentsTable ' WHERE Bug_ID = "' $vBug_ID '"';
			Inline: $IV_SearchComments, -SQL=$SQLDeleteComments; /Inline;

			// Delete all Changelog entries
			Var:'SQLDeleteChangelog' = 'DELETE FROM ' $svChangelogTable ' WHERE Bug_ID = "' $vBug_ID '"';
			Inline: $IV_SearchChangelog, -SQL=$SQLDeleteChangelog; /Inline;

		Else;
			Var:'vError' = '1022';
			Var:'vOption' = (Error_CurrentError);
			Var:'URL' = ('bugs_edit.lasso?Error='$vError'&Option='$vOption);
			If: $svDebug == 'Y';
				'298: URL: ' $URL '<br>\n';
				'<a href="'$URL'">' $URL '</a><br>\n';
			Else;
				Redirect_URL: $URL;
			/If;
		/If;
	/Inline;

// ============= ATTACHMENTS ========
Else: $vAction == 'Upload';

	Include:($svLibsPath)'process_uploads.inc';

	// Add a Changelog entry
	Include:($svLibsPath)'add_changelog.inc';

// Referrer not good, somebody is messing with us
// Dump out error 9002, "Database Error"
Else;
	Var:'vError' = '9002';
/If;


// Deal with the results of the processing

// ============= ADD ========
// If any other error other than 1001 "Add Successful" do a redirect
If: $vAction == 'Add';
	// Standard Error Table
	If: (Var:'vError') == '1001';
		Show_Error: -ErrNum=(Var:'vError'), -Option=(Var:'vOption'), -PosColor='00CC00', -NegColor='FF0000', -BgColor='F0F1F1';

// Edit New Listing Link -->
?>
<div align="left">
	View the record for <a href="/admin/bugs_editrecord.lasso?BugID=[Var:'vNewBug_ID']&New=Y"><b>[$vDisplayName]</b></a>
</div>
<?Lassoscript
	Else;
		Var:'URL' = ('bugs_add.lasso?Error='$vError'&Option='$vOption'&'(Client_POSTArgs));
		If: $svDebug == 'Y';
			'339: URL = ' $URL '<br>\n';
		'<a href="'$URL'">' $URL '</a><br>\n';
		Else;
			Redirect_URL: $URL;
		/If;
	/If;
/If;


// ============= EDIT ========
// If vAction = Edit, Always redirect to edit page
// If record updated OK, will get a 1011 "Update Successful" message, but do NOT pass the Params, only the ID
// This forces the system to do a new lookup
If: $vAction == 'Update' || $vAction == 'Add Comment';
	If: (Var:'vError') == '1011';
		Var:'URL' = ('/admin/bugs_editrecord.lasso?BugID='$vNewBug_ID'&New=Y&Error='$vError);
	Else: (Var:'vError') == '1001';
		Var:'URL' = ('/admin/bugs_editrecord.lasso?BugID='$vBug_ID'&New=Y&Error='$vError'&Option='$vOption);
	Else;
		Var:'URL' = ('/admin/bugs_editrecord.lasso?New=Y&Error='$vError'&Option='$vOption'&'(Client_POSTArgs));
	/If;
	If: $svDebug == 'Y';
		'361: URL = ' $URL '<br>';
		'<a href="'$URL'">' $URL '</a><br>\n';
	Else;
		Redirect_URL: $URL;
	/If;
// ============= DELETE ========
// If Action = Delete, redirect to Bugs Summary page
Else: $vAction == 'Delete';
	Var:'URL' = ('bugs.lasso?Error='$vError'&Option='$vOption);
	If: $svDebug == 'Y';
		'371: URL = ' $URL '<br>';
		'<a href="'$URL'">' $URL '</a><br>\n';
	Else;
		Redirect_URL: $URL;
	/If;
/If;


// ============= ATTACHMENT ========
// If vAction = Attachment, Always redirect to issue page
// If record updated OK, will get a 1011 "Update Successful" message, but do NOT pass the Params, only the ID
// This forces the system to do a new lookup
If: $vAction == 'Upload';
	Var:'URL' = ('/admin/bugs_editrecord.lasso?BugID='$vBug_ID'&New=Y&Error='$vError);
	If: $svDebug == 'Y';
		'386: URL = ' $URL '<br>';
		'<a href="'$URL'">' $URL '</a><br>\n';
	Else;
		Redirect_URL: $URL;
	/If;
/If;
?>
